/**
 * @license Copyright (c) 2003-2023, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

import GoogleSheetsNormalizer from '../../src/normalizers/googlesheetsnormalizer';

// `execute()` of the google sheets normalizer is tested with autogenerated normalization tests.
describe( 'GoogleSheetsNormalizer', () => {
	const normalizer = new GoogleSheetsNormalizer();

	describe( 'isActive()', () => {
		it( 'should return true from google sheets content', () => {
			expect(
				normalizer.isActive(
					'<google-sheets-html-origin>' +
						'<table xmlns="http://www.w3.org/1999/xhtml" style="width:0px">' +
							'<tr>' +
								'<td>123</td>' +
							'</tr>' +
						'</table>' +
					'<google-sheets-html-origin>'
				)
			).to.be.true;
		} );

		it( 'should return false for regular tables', () => {
			expect( normalizer.isActive( '<table><tr><td>123</td></tr></table>' ) ).to.be.false;
		} );

		it( 'should return false for content form other sources', () => {
			expect( normalizer.isActive( '<p>foo</p>' ) ).to.be.false;
		} );
	} );
} );
