---
# Scope:
# * Serve as a single point for the most common questions.
# * Drive the user to other parts of documentation.
# * Bring knowledge for topics not covered in other parts of the documentation.

category: support
order: 40
---

# Reporting issues

If you feel you found an issue in CKEditor 5, we will be grateful for letting us know. Before you create a bug report, please read the guidelines on how to do it properly and most efficiently.

## Reproduce on official examples

To eliminate the chance that the issue might be caused by some third-party software or your customizations, try to reproduce the issue on the {@link examples/index official examples} first.

The examples are always running the latest editor version. Please note that if the problem was fixed in one of the releases that succeeded the version you are using, you will need to upgrade your CKEditor 5 installation as we do not backport fixes.

Most of the issues are reproducible on the demo. If you have a different case though, no problem. Go ahead with the next steps.

## Reporting issues

All issues should be reported in the [CKEditor 5 repository](https://github.com/ckeditor/ckeditor5/issues) on GitHub, except ones that are related to one of the following projects (that have their own issue pages):

* [Angular integration](https://github.com/ckeditor/ckeditor5-angular),
* [React integration](https://github.com/ckeditor/ckeditor5-react),
* [Vue integration](https://github.com/ckeditor/ckeditor5-vue),
* [CKEditor 5 inspector](https://github.com/ckeditor/ckeditor5-inspector).

Things to keep in mind:

* Search for existing issues before starting a new one. This helps our team to have the backlog in order.
* Be concise and informative, making it easy for our team to understand the problem.
* Do not use the issues pages for asking for help. The project has other {@link support/index communication channels} for that purpose.
* Feel free to jump into discussions around issues, exposing your opinion!

Issues with third-party plugins should be reported directly to their developers.
